//
//  fd-access.h
//
//  Created by Chris Suter on 29/10/10.
//  Copyright (c) 2010 Coriolis Systems Ltd. All rights reserved.
//

#ifndef FD_ACCESS_H_
#define FD_ACCESS_H_

#include <sys/types.h>
#include <stdbool.h>
#include <fcntl.h>
#include "helper.h"

typedef enum {
  NoAccess,
  ReadAccess,
  ReadWriteAccess,
  ReadWriteCreateAccess,
} access_t;

// Used by auth_open
enum {
  O_WITHINTERACTION = 0x80000000,
};

#if !HELPER

// NOTE: These two use errno
int auth_open (const char *path, int oflag, ...);
int auth_chown (const char *path, uid_t uid, gid_t gid);

// NOTE: These don't use errno
int auth_openx (const char *path, int oflag, mode_t mode,
		Interaction interaction, const char *right, int *pfd);
int revoke_access (const char *path, access_t level);
int authorise_global (const char *right, Interaction interaction);
int authorise_access (const char *path, int oflag, Interaction interaction);

int auth_unlink (const char *path);

#endif

#endif // FD_ACCESS_H_
